import time,sys,thread
from visual import *
##from win32com.client import Dispatch


class DataOut:
    def __init__(self, trackSpins, numerics):
        self.trackSpins = trackSpins
        self.numerics = numerics

        self.planeFlag = 0
        self.planeFlag2 = 0
        self.wasDownBefore = 0
        
        self.planes = 0
        self.dESum = 0.0
        self.dTSum = 0.0
        
        self.timeOfOld = 0.0
        self.timeOfNew = 0.0

        self.B12EOfOld = 0.0
        self.B12EOfNew = 0.0
        
        self.dotSumOld = 3.0
        self.dotSumNew = 0.0
       
    def excelLog(self, duration):
##        self.numerics.reset()
        
        Esum = self.numerics.returnTotalEnergy()
        Zsum = mag(self.numerics.returnSpinSum())      
        
        self.xlApp = Dispatch("Excel.Application")
        self.xlApp.Visible = 1
        self.xlApp.Workbooks.Add()

        self.xlApp.ActiveSheet.Cells(1,1).Value = 'Collected:'
        self.xlApp.ActiveSheet.Cells(1,2).Value = time.ctime()
        self.xlApp.ActiveSheet.Cells(1,4).Value = 'dt'
        self.xlApp.ActiveSheet.Cells(1,5).Value = self.numerics.dt

##        self.xlApp.ActiveSheet.Cells(3,1).Value = 'phi H'
##        self.xlApp.ActiveSheet.Cells(3,2).Value = self.numerics.phiH
##        self.xlApp.ActiveSheet.Cells(4,1).Value = 'phi T'
##        self.xlApp.ActiveSheet.Cells(4,2).Value = self.numerics.phiT
        self.xlApp.ActiveSheet.Cells(5,1).Value = 'Total Sz:'
        self.xlApp.ActiveSheet.Cells(5,2).Value = Zsum 

        self.xlApp.ActiveSheet.Cells(7,1).Value = 'Jb/Ja:'
        self.xlApp.ActiveSheet.Cells(7,2).Value = self.numerics.Jbx/self.numerics.Ja
        self.xlApp.ActiveSheet.Cells(8,1).Value = 'Total Energy:'
        self.xlApp.ActiveSheet.Cells(8,2).Value = Esum
        
        self.xlApp.ActiveSheet.Cells(10,1).Value = 'Energies:'

        self.xlApp.ActiveSheet.Cells(11,1).Value = 'Sx'
        self.xlApp.ActiveSheet.Cells(11,2).Value = 'Sy'
        self.xlApp.ActiveSheet.Cells(11,3).Value = 'Sz'

        cell = 0
        while cell < 2000:
            cell += 1

            spinArray = self.numerics.returnState()
            
            time.sleep(.1)
            
            self.xlApp.ActiveSheet.Cells(12+cell,1).Value = spinArray[8][0][0][0]
            self.xlApp.ActiveSheet.Cells(12+cell,2).Value = spinArray[8][0][0][1]
            self.xlApp.ActiveSheet.Cells(12+cell,3).Value = spinArray[8][0][0][2]


            

                
        self.xlApp.ActiveWorkbook.Close(SaveChanges=1)
        self.xlApp.Quit()
        del self.xlApp

        self.reset()


        
##    def excelLog(self, duration):
####        self.numerics.reset()
##        
##        Esum = self.numerics.returnTotalEnergy()
##        Zsum = mag(self.numerics.returnSpinSum())      
##        
##        self.xlApp = Dispatch("Excel.Application")
##        self.xlApp.Visible = 1
##        self.xlApp.Workbooks.Add()
##
##        self.xlApp.ActiveSheet.Cells(1,1).Value = 'Collected:'
##        self.xlApp.ActiveSheet.Cells(1,2).Value = time.ctime()
##        self.xlApp.ActiveSheet.Cells(1,4).Value = 'dt'
##        self.xlApp.ActiveSheet.Cells(1,5).Value = self.numerics.dt
##
####        self.xlApp.ActiveSheet.Cells(3,1).Value = 'phi H'
####        self.xlApp.ActiveSheet.Cells(3,2).Value = self.numerics.phiH
####        self.xlApp.ActiveSheet.Cells(4,1).Value = 'phi T'
####        self.xlApp.ActiveSheet.Cells(4,2).Value = self.numerics.phiT
##        self.xlApp.ActiveSheet.Cells(5,1).Value = 'Total Sz:'
##        self.xlApp.ActiveSheet.Cells(5,2).Value = Zsum 
##
##        self.xlApp.ActiveSheet.Cells(7,1).Value = 'Jb/Ja:'
##        self.xlApp.ActiveSheet.Cells(7,2).Value = self.numerics.Jbx/self.numerics.Ja
##        self.xlApp.ActiveSheet.Cells(8,1).Value = 'Total Energy:'
##        self.xlApp.ActiveSheet.Cells(8,2).Value = Esum
##        
##        self.xlApp.ActiveSheet.Cells(10,1).Value = 'Energies:'
##
##        self.xlApp.ActiveSheet.Cells(11,1).Value = 'Time'
##        self.xlApp.ActiveSheet.Cells(11,2).Value = 'Bond 12'
##        self.xlApp.ActiveSheet.Cells(11,3).Value = 'Bond 23'
##        self.xlApp.ActiveSheet.Cells(11,4).Value = 'Bond 31'
##        self.xlApp.ActiveSheet.Cells(11,5).Value = 'Spin 1'
##        self.xlApp.ActiveSheet.Cells(11,6).Value = 'Spin 2'
##        self.xlApp.ActiveSheet.Cells(11,7).Value = 'Spin 3'
##        self.xlApp.ActiveSheet.Cells(11,8).Value = 'Spin 4'
##        self.xlApp.ActiveSheet.Cells(11,9).Value = 'Spin 5'
##        self.xlApp.ActiveSheet.Cells(11,10).Value = 'Spin 6'
##
##        offset = 11
##        cell = 0
##        peaks = 0
##        
##        while peaks < duration:
##            cell += 1
##            spinArray = self.numerics.returnState()
##            energyArray = self.numerics.returnEnergies()
##            bondEnergyArray = self.numerics.returnBondXEnergies()
##
##            self.xlApp.ActiveSheet.Cells(offset + cell,1).Value = self.numerics.t
##            self.xlApp.ActiveSheet.Cells(offset + cell,2).Value = bondEnergyArray[0]
##            self.xlApp.ActiveSheet.Cells(offset + cell,3).Value = bondEnergyArray[1]
##            self.xlApp.ActiveSheet.Cells(offset + cell,4).Value = bondEnergyArray[2]
##            self.xlApp.ActiveSheet.Cells(offset + cell,5).Value = energyArray[0][0]
##            self.xlApp.ActiveSheet.Cells(offset + cell,6).Value = energyArray[1][0]
##            self.xlApp.ActiveSheet.Cells(offset + cell,7).Value = energyArray[2][0]
##            self.xlApp.ActiveSheet.Cells(offset + cell,8).Value = energyArray[0][1]
##            self.xlApp.ActiveSheet.Cells(offset + cell,9).Value = energyArray[1][1]
##            self.xlApp.ActiveSheet.Cells(offset + cell,10).Value = energyArray[2][1]
##          
##        self.xlApp.ActiveWorkbook.Close(SaveChanges=1)
##        self.xlApp.Quit()
##        del self.xlApp
##
##        self.reset()



    def reset(self):
        self.planeFlag = 0
        self.planeFlag2 = 0
        self.wasDownBefore = 0
        
        self.planes = 0
        self.dESum = 0.0
        self.dTSum = 0.0
        
        self.timeOfOld = 0.0
        self.timeOfNew = 0.0

        self.B12EOfOld = 0.0
        self.B12EOfNew = 0.0
        
        self.dotSumOld = 3.0
        self.dotSumNew = 0.0















        


##from AnglePlot import *
##from PhaseSpace import *
##from FFTPlot import *
##from PowerSpectra import *
##
##
##        self.planeFlag = 0
##        self.timeOfA = 0.0
##        self.timeOfB = 0.0
##
##        self.dotSumOld = 0.0
##        self.dotSumNew = 0.0
##
##        self.powerSpectraTime = 30.0
##        self.powerSpectraTimeClk = 30.0
##
##        self.phaseSpace.window.select()
##
##        if self.tvPlotAngles.get() == 1:        self.anglePlot.updateCurves(self.t)
##        if self.tvPhasePoints.get() == 1:       self.phaseSpace.addPoint()
##        if self.tvReturnMap.get() == 1:         self.phaseSpace.returnMap()
##        if self.tvPlotFFT.get() == 1:           self.FFTPlot.plotXYtransform()
##        if self.tvTrackMaxMin.get() == 1:       self.checkCoplanar()
##
##        if self.tvGetPS.get() == 1:
##            if self.powerSpectraTimeClk >= 0.0:
##                self.powerSpectraTimeClk -= self.dt
##                self.powerSpectra.SpectraToFile(self.t)
##            else:
##                self.tvGetPS.set(0)
##                self.powerSpectraTimeClk = self.powerSpectraTime
##                self.powerSpectra.WriteFFT()
##
##        self.anglePlot = AnglePlot(self.nSpinsX, self.nSpinsY, self.nLattice)
##        self.phaseSpace = PhaseSpace(self.nSpinsX, self.nSpinsY, self.nLattice)
##        self.FFTPlot = FFTPlot(self.nSpinsX, self.nSpinsY, self.nLattice)
##        self.powerSpectra = PowerSpectra(self.nSpinsX, self.nSpinsY, self.nLattice, self.dt, self.Jbx, self.powerSpectraTime)








##            if self.checkCoplanar(self.numerics.t, spinArray, bondEnergyArray):
##                self.xlApp.ActiveSheet.Cells(offset + cell,9).Value = 'Half Period:'
##                self.xlApp.ActiveSheet.Cells(offset + cell,10).Value = self.timeOfNew - self.timeOfOld
##                self.xlApp.ActiveSheet.Cells(offset + cell+1,9).Value = 'Bond 12 dE'
##                self.xlApp.ActiveSheet.Cells(offset + cell+1,10).Value = abs(self.B12EOfNew - self.B12EOfOld)
##
##                peaks += 1

##        self.xlApp.ActiveSheet.Cells(2,4).Value = 'Averages:'
##        self.xlApp.ActiveSheet.Cells(3,4).Value = 'Period:'
##        self.xlApp.ActiveSheet.Cells(3,5).Value = 2.0*self.dTSum/self.planes
##        self.xlApp.ActiveSheet.Cells(4,4).Value = 'Bond 12 dE:'
##        self.xlApp.ActiveSheet.Cells(4,5).Value = self.dESum/self.planes
##
##        self.xlApp.ActiveSheet.Cells(7,4).Value = 'Frequency:'
##        self.xlApp.ActiveSheet.Cells(7,5).Value = 0.5/(self.dTSum/self.planes)
##        self.xlApp.ActiveSheet.Cells(8,4).Value = 'Amplitude:'
##        self.xlApp.ActiveSheet.Cells(8,5).Value = 0.5*self.dESum/self.planes




##
##    def checkCoplanar(self, t, spinArray, bondEnergyArray):
##        cross12 = norm(cross(spinArray[0][0][0],spinArray[1][0][0]))
##        cross23 = norm(cross(spinArray[1][0][0],spinArray[2][0][0]))
##        cross31 = norm(cross(spinArray[2][0][0],spinArray[0][0][0]))
##
##        dot2 = abs(dot(cross12,cross23))    # how much spin 2 is in the plane of spin 1 and 3
##        dot3 = abs(dot(cross23,cross31))
##        dot1 = abs(dot(cross31,cross12))
##
##        self.dotSumNew = abs(dot1)+abs(dot2)+abs(dot3)       
##                                                    
##        if self.dotSumNew < self.dotSumOld:       # within dt of being coplanar
##            if self.wasDownBefore == 1:
##                if self.planeFlag == 0:
##                    self.planeFlag = 1
##                    
##                    if self.timeOfNew == 0.0:
##                        self.timeOfNew = t
##                        self.B12EOfNew = bondEnergyArray[0]
##                    else:
##                        self.planeFlag2 = 1 
##                        self.planes += 1
##                        
##                        self.timeOfOld = self.timeOfNew
##                        self.timeOfNew = self.numerics.t
##                        
##                        self.B12EOfOld = self.B12EOfNew
##                        self.B12EOfNew = bondEnergyArray[0]               
##
##                        self.dTSum += abs(self.timeOfNew - self.timeOfOld)
##                        self.dESum += abs(self.B12EOfNew - self.B12EOfOld)
##                        
####                        print '\nSpins 123 Coplanar:'
####                        print 'Delta t from Last:', self.timeOfNew - self.timeOfOld
####
####                        print 'Spin 1-2 Angle:', (180.0/pi)*arccos(dot(spinArray[0][0][0],spinArray[1][0][0]))
####                        print 'Spin 2-3 Angle:', (180.0/pi)*arccos(dot(spinArray[1][0][0],spinArray[2][0][0]))
####                        print 'Spin 3-1 Angle:', (180.0/pi)*arccos(dot(spinArray[2][0][0],spinArray[0][0][0]))
##                else:
##                    self.planeFlag2 = 0
##
##
##        if self.dotSumNew > self.dotSumOld:       # on approach
##            self.wasDownBefore = 1
##            if self.planeFlag == 1:
##                self.planeFlag = 0
##                
##        self.dotSumOld = self.dotSumNew
##
##        return self.planeFlag2        
##
##
##
##  
##
##
##    def powerSpectra(self):
##        self.tvGetPS.set(1)
##
##    def deltaE(self):
##        self.nLattice.getEnergies()
##        deltaEArray = self.nLattice.minEnergyArray - self.nLattice.maxEnergyArray
##        print 'delta E Array:\n', deltaEArray
##        self.nLattice.clearEnergies()
##
##
##
##    def checkCoplanar(self):
##        cross12 = norm(cross(self.nLattice.spinArray[0][0][0],self.nLattice.spinArray[1][0][0]))
##        cross23 = norm(cross(self.nLattice.spinArray[1][0][0],self.nLattice.spinArray[2][0][0]))
##        cross31 = norm(cross(self.nLattice.spinArray[2][0][0],self.nLattice.spinArray[0][0][0]))
##
##        dot2 = abs(dot(cross12,cross23)) # how much spin 2 is in the plane of spin 1 and 3
##        dot3 = abs(dot(cross23,cross31))
##        dot1 = abs(dot(cross31,cross12))
##
##        self.dotSumNew = dot1+dot2+dot3
##        
##        if self.dotSumNew < self.dotSumOld and self.planeFlag == 0:       # just left plane, should be within dt of it.
##            self.planeFlag = 1
##            self.timeOfA = self.timeOfB
##            self.timeOfB = self.t
##
##            print '\nSpins 123 Coplanar:'
##            print 'Delta t from Last:', self.timeOfB - self.timeOfA
##            print 'Spin 1-2 Angle:', (180.0/pi)*arccos(dot(self.nLattice.spinArray[0][0][0],self.nLattice.spinArray[1][0][0]))
##            print 'Spin 2-3 Angle:', (180.0/pi)*arccos(dot(self.nLattice.spinArray[1][0][0],self.nLattice.spinArray[2][0][0]))
##            print 'Spin 3-1 Angle:', (180.0/pi)*arccos(dot(self.nLattice.spinArray[2][0][0],self.nLattice.spinArray[0][0][0]))
##    ##                            print 'Spin 1-z Angle:', (180.0/pi)*arccos(dot(self.nLattice.spinArray[0][0][0],vector(0.0,0.0,1.0)))
##    ##                            print 'Spin 2-z Angle:', (180.0/pi)*arccos(dot(self.nLattice.spinArray[1][0][0],vector(0.0,0.0,1.0)))
##    ##                            print 'Spin 3-z Angle:', (180.0/pi)*arccos(dot(self.nLattice.spinArray[2][0][0],vector(0.0,0.0,1.0)))
##                                       
##        if self.dotSumNew > self.dotSumOld and self.planeFlag == 1:       # on approach
##            self.planeFlag = 0
##
##        self.dotSumOld = self.dotSumNew      
##
##
##
##        
##
##    def reset(self):
##        self.phaseSpace.resetPoints()
##        self.anglePlot.resetPlots()
##
##
##    def clear(self):
##        self.t = 0.000
##        self.phaseSpace.resetPoints()
##        self.anglePlot.resetPlots() 
##
##
##        
